/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.internal.action.Program;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class FormTextPart
implements Part {
    private StringBuffer content = new StringBuffer();
    private ScrolledComposite container = null;
    private FormText text = null;

    public FormTextPart() {
    }

    public FormTextPart(String text) {
        this.setText(text);
    }

    public FormTextPart(Reader text) throws IOException {
        this.setText(text);
    }

    public void setText(Reader text) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(text);
            String thisLine = null;
            StringBuffer buffer = new StringBuffer();
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.length() == 0) {
                    buffer.append("\n\n");
                    continue;
                }
                buffer.append(thisLine.trim() + " ");
            }
            this.content = buffer;
            this.refresh();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{br});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{br});
    }

    public void setText(String s) {
        this.content = new StringBuffer(s);
        this.refresh();
    }

    public void refresh() {
        if (this.text == null || this.content == null) {
            return;
        }
        String s = this.content.toString();
        boolean b = s != null && s.startsWith("<form>");
        this.text.setText(s == null ? "" : s, b, b);
        this.resize();
    }

    private void resize() {
        if (this.text == null || this.container == null) {
            return;
        }
        this.text.setSize(this.text.computeSize(this.text.getParent().getClientArea().width, -1));
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        this.container = new ScrolledComposite(parent, 768);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 4;
        this.container.setLayoutData((Object)gd);
        this.container.setLayout((Layout)SWTUtil.createGrid(1, true));
        this.container.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FormTextPart.this.resize();
            }
        });
        this.text = new FormText((Composite)this.container, 64);
        HyperlinkSettings hs = new HyperlinkSettings(GUI.getDisplay());
        hs.setBackground(Color.BACKGROUND.getSWTColor());
        hs.setForeground(Color.LINK.getSWTColor());
        hs.setActiveBackground(Color.BACKGROUND.getSWTColor());
        hs.setActiveForeground(Color.LINK_ACTIVE.getSWTColor());
        this.text.setHyperlinkSettings(hs);
        this.text.setFont(Font.DEFAULT.getSWTFont());
        this.text.setColor("header", Color.COMMENT.getSWTColor());
        this.text.setColor("error", Color.ERROR.getSWTColor());
        this.text.setColor("success", Color.SUCCESS.getSWTColor());
        this.text.setFont("header", Font.H1.getSWTFont());
        this.container.setContent((Control)this.text);
        this.text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                if (href == null) {
                    Logger.info((String)"got hyperlink event, but data was null. nothing to do");
                    return;
                }
                if (!(href instanceof String)) {
                    Logger.info((String)"got hyperlink event, but data is not a string, skipping");
                    return;
                }
                String action = (String)href;
                Logger.info((String)("executing action \"" + action));
                try {
                    Logger.debug((String)("trying to load class " + action));
                    Class c = Application.getClassLoader().load(action);
                    BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                    Action a = (Action)beanService.get(c);
                    a.handleAction(e);
                    return;
                }
                catch (Throwable c) {
                    try {
                        new Program().handleAction(action);
                    }
                    catch (ApplicationException ae) {
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                    }
                    return;
                }
            }
        });
        this.refresh();
    }
}

